using log4net;
using Microsoft.Azure.WebJobs;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.ProviderService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class ProviderQueueTrigger
    {
        [FunctionName("ProviderQueueTrigger")]
        public static async Task Run([QueueTrigger("%CcnInitialDocRef_QueueName%", Connection = "AzureWebJobsStorage")]string providerQueueItem,
            [Inject]IProviderService providerService,
            [Inject] ILog logger)
        {
            try
            {
                logger.Info($"Start ProviderQueueTrigger function processed: {providerQueueItem}");

                await providerService.ProcessProvider(providerQueueItem);

                logger.Info($"End ProviderQueueTrigger function processed: {providerQueueItem}");
            }
            catch (Exception ex)
            {
                logger.Error($"There was a problem with ProviderQueueTrigger Processing for Provider: {providerQueueItem}.", ex);
            }
        }
    }
}